%readthu1mc3m.m reads raw sbe microcat KAUST data
% RL 10/12/08   Rabigh apr-oct 2008
clear;

%thu 5668 Clock check ok
depth=4;
latitude=22+44.076/60;%;
longitude= -038-59.657/60;
instdepth=3; SN='SBE 37 - 5668'; mooring='thu';
sample=5;%sampling interval in minutes

perl fixmcat.plx mc5483oct08.asc
load 'fixed.dat';z=fixed;!del fixed.dat
jday=julian([z(:,5) z(:,4) z(:,3) z(:,6) z(:,7) 0*z(:,8)]);
temp=z(:,1);cond=10*z(:,2); clear z

%Calibration
% T residual=xxxx; C residual = yyyy  Oct08

%Truncate so only data in water
st=julian([2008  4 20 11 20 00]);%thu deploy 1
et=julian([2008 10 13 9 15 00]);%thu 
n=find(jday<st);jday(n)=[];temp(n,:)=[];cond(n,:)=[];
n=find(jday>et);jday(n)=[];temp(n,:)=[];cond(n,:)=[];

cndr = cond/sw_c3515;t68=1.00024*temp;
salt = sw_salt(cndr,t68,sw_pres(instdepth,latitude));

clf;subplot(2,1,1)
set(gca,'fonts',12)
plot(jday,temp)
set(gca,'fontw','bold')
gregaxd(jday,31);grid
ylabel('Temp ^oC')
h=title('Rabigh Mcat 300s');set(h,'fonts',14,'fontw','bold')

subplot(2,1,2)
%n=find(salt<34.0);sal(n)=nan;
set(gca,'fonts',12)
plot(jday,salt)
set(gca,'fontw','bold')
gregaxd(jday,31);grid
ylabel('Salinity psu')

figure(gcf)
%wysiwyg
jdaymc1=jday;tempmc1=temp;condmc1=cond;saltmc1=salt;depthmc1=depth;instdepthmc1=instdepth;
save rab1mc3m300s jdaymc1 tempmc1 condmc1  saltmc1 SN depthmc1 latitude longitude instdepthmc1
print -djpeg99 -r300 rabigh_mc_300sec